/* Mode choice */
/*mode_data data has rows that are mode (8) x yr (2004:14) and cols that are*/
/*regions(12) and hh*/
mata
mode_input = (2004..2014)
mode_input_t = length(mode_input)
mode_backcast = length(1992..2003)
mode_forecast = length(2021..2050)
mode_names = ("bus","cycle","drive","other","passenger","taxi","train","walk")
akl_wel_mode_n = 8
regional_mode_n = 5
mode_n = length(mode_names)
model2geo = (1,	2,	3,	4,	11,	5,	6,	7,	12,	8,	9,	10)
alph2geo = (6,	1,	11,	2,	4,	9,	5,	12,	10,	3,	7,	8)
cost_back_i = J(j_t,j_r*j_h,0)
for (i = 1; i<=12; i++){
	for (j=1; j<=6; j++){
   	 cost_back_i[.,i+j] = cost_back[.,alph2geo[i]+j]
	}
}
cost_back = cost_back_i

/*To convert model reg order to alphabetical: 2,4,8,11,6,1,9,10,5,12,3,7*/
/*To convert alphabetical regions to model order*/

/* Incomes */
reg_inc_georder = J(TL,12*6,0)
for (i = 1; i <= 12; i++){
	for (j=1; j<=6; j++){
		reg_inc_georder[.,(i-1)*6+j] = inc_hrt[.,(alph2geo[i]-1)*6+j]
	}
}
/*(1)(a) Bus cost*/
bus_cost = J(j_t,j_r*j_h,0)
bus_cost[mode_backcast+1..mode_backcast+mode_input_t,.] = cost_perk[1..mode_input_t*1,.]
/*bus_cost_hrt = J(j_t,j_r*j_h,bus_cost)*/
bus_cost_hrt = bus_cost
for (i=1; i<=mode_backcast; i++){
    bus_cost_hrt[mode_backcast+1-i,.]= bus_cost[mode_backcast+2-i,.]:*cost_back[mode_backcast+1-i,.]
}

for (i=mode_backcast+mode_input_t; i<=mode_backcast+mode_input_t+mode_forecast-1; i++){
    bus_cost_hrt[i+1,.]= bus_cost_hrt[i,.]:*(cost_fwd[i+1,.]+ pt_price_scenario_fwd[i+1,.])
}

bus_cost_inc = (bus_cost_hrt:/reg_inc_georder)*100000
bus_cost_inc=editmissing(bus_cost_inc,0)

/*(1) (b) Bus time*/
bus_time = J(j_t,j_r*j_h,0)
bus_time[mode_backcast+1..mode_backcast+mode_input_t,.] = mode_time[1..mode_input_t*1,.]
bus_time_hrt = bus_time

time_back = J(mode_backcast,1,bus_time_hrt[mode_backcast+1,.])
time_fwd = J(mode_forecast,1,bus_time_hrt[mode_backcast+mode_input_t,.])
bus_time_hrt = (time_back\bus_time_hrt[mode_backcast+1..mode_backcast+mode_input_t,.]\J(6,1,bus_time_hrt[mode_backcast+mode_input_t,.])\time_fwd)

/*(1) (c) Bus peak*/
bus_peak = J(j_t,j_r*j_h,0)
bus_peak[mode_backcast+1..(mode_backcast+mode_input_t),.] = peak[1..(mode_input_t*1),.]
bus_peak_hrt = J(1,j_r*j_h,bus_peak)
peak_back = J(mode_backcast,1,bus_peak_hrt[mode_backcast+1,.])
peak_fwd = J(mode_forecast,1,bus_peak_hrt[mode_backcast+mode_input_t,.])
bus_peak_hrt = (peak_back\bus_peak_hrt[(mode_backcast+1)..(mode_backcast+mode_input_t),.]\J(6,1,bus_peak_hrt[mode_backcast+mode_input_t,.])\peak_fwd)

/*(2)(a) Cycle cost*/
cycle_cost = J(j_t,j_r*j_h,0)
cycle_cost[mode_backcast+1..mode_backcast+mode_input_t,.] = cost_perk[mode_input_t+1..mode_input_t*2,.]
/*cycle_cost_hrt = J(j_t,j_r*j_h,cycle_cost)*/
cycle_cost_hrt = cycle_cost
for (i=1; i<=mode_backcast; i++){
    cycle_cost_hrt[mode_backcast+1-i,.]= cycle_cost[mode_backcast+2-i,.]:*cost_back[mode_backcast+1-i,.]
}

for (i=mode_backcast+mode_input_t; i<=mode_backcast+mode_input_t+mode_forecast-1; i++){
    cycle_cost_hrt[i+1,.]= cycle_cost_hrt[i,.]:*(cost_fwd[i+1,.]+ pt_price_scenario_fwd[i+1,.])
}

cycle_cost_inc = (cycle_cost_hrt:/reg_inc_georder)*100000
cycle_cost_inc=editmissing(cycle_cost_inc,0)

/*(2) (b) Cycle time*/
cycle_time = J(j_t,j_r*j_h,0)
cycle_time[mode_backcast+1..mode_backcast+mode_input_t,.] = mode_time[mode_input_t+1..mode_input_t*2,.]
cycle_time_hrt = cycle_time

time_back = J(mode_backcast,1,cycle_time_hrt[mode_backcast+1,.])
time_fwd = J(mode_forecast,1,cycle_time_hrt[mode_backcast+mode_input_t,.])

cycle_time_hrt = (time_back\cycle_time_hrt[mode_backcast+1..mode_backcast+mode_input_t,.]\J(6,1,cycle_time_hrt[mode_backcast+mode_input_t,.])\time_fwd)

/*(2) (c) Cycle peak*/
cycle_peak = J(j_t,j_r*j_h,0)
cycle_peak[mode_backcast+1..(mode_backcast+mode_input_t),.] = peak[mode_input_t*1+1..mode_input_t*2,.]
cycle_peak_hrt = J(1,j_r*j_h,cycle_peak)
peak_back = J(mode_backcast,1,cycle_peak_hrt[mode_backcast+1,.])
peak_fwd = J(mode_forecast,1,cycle_peak_hrt[mode_backcast+mode_input_t,.])
cycle_peak_hrt = (peak_back\cycle_peak_hrt[(mode_backcast+1)..(mode_backcast+mode_input_t),.]\J(6,1,cycle_peak_hrt[mode_backcast+mode_input_t,.])\peak_fwd)

/*(3)(a) Drive cost*/
drive_cost = J(j_t,j_r*j_h,0)
drive_cost[mode_backcast+1..mode_backcast+mode_input_t,.] = cost_perk[mode_input_t*2+1..mode_input_t*3,.]
/*drive_cost_hrt = J(j_t,j_r*j_h,drive_cost)*/
drive_cost_hrt = drive_cost
for (i=1; i<=mode_backcast; i++){
    drive_cost_hrt[mode_backcast+1-i,.]= drive_cost[mode_backcast+2-i,.]:*cost_back[mode_backcast+1-i,.]
}

for (i=mode_backcast+mode_input_t; i<=mode_backcast+mode_input_t+mode_forecast-1; i++){
    drive_cost_hrt[i+1,.]= drive_cost_hrt[i,.]:*(cost_fwd[i+1,.]+ pt_price_scenario_fwd[i+1,.])
}

drive_cost_inc = (drive_cost_hrt:/reg_inc_georder)*100000
drive_cost_inc=editmissing(drive_cost_inc,0)

/*(3) (b) Drive time*/
drive_time = J(j_t,j_r*j_h,0)
drive_time[mode_backcast+1..mode_backcast+mode_input_t,.] = mode_time[mode_input_t*2+1..mode_input_t*3,.]
drive_time_hrt = drive_time

time_back = J(mode_backcast,1,drive_time_hrt[mode_backcast+1,.])
time_fwd = J(mode_forecast,1,drive_time_hrt[mode_backcast+mode_input_t,.])
drive_time_hrt = (time_back\drive_time_hrt[mode_backcast+1..mode_backcast+mode_input_t,.]\J(6,1,drive_time_hrt[mode_backcast+mode_input_t,.])\time_fwd)

/*(3) (c) Drive peak*/
drive_peak = J(j_t,j_r*j_h,0)
drive_peak[mode_backcast+1..(mode_backcast+mode_input_t),.] = peak[mode_input_t*2+1..mode_input_t*3,.]
drive_peak_hrt = J(1,j_r*j_h,drive_peak)
peak_back = J(mode_backcast,1,drive_peak_hrt[mode_backcast+1,.])
peak_fwd = J(mode_forecast,1,drive_peak_hrt[mode_backcast+mode_input_t,.])
drive_peak_hrt = (peak_back\drive_peak_hrt[(mode_backcast+1)..(mode_backcast+mode_input_t),.]\J(6,1,drive_peak_hrt[mode_backcast+mode_input_t,.])\peak_fwd)

/*(4)(a) Other cost*/
other_cost = J(j_t,j_r*j_h,0)
other_cost[mode_backcast+1..mode_backcast+mode_input_t,.] = cost_perk[mode_input_t*3+1..mode_input_t*4,.]
/*other_cost_hrt = J(j_t,j_r*j_h,other_cost)*/
other_cost_hrt = other_cost
for (i=1; i<=mode_backcast; i++){
    other_cost_hrt[mode_backcast+1-i,.]= other_cost[mode_backcast+2-i,.]:*cost_back[mode_backcast+1-i,.]
}

for (i=mode_backcast+mode_input_t; i<=mode_backcast+mode_input_t+mode_forecast-1; i++){
    other_cost_hrt[i+1,.]= other_cost_hrt[i,.]:*(cost_fwd[i+1,.]+ pt_price_scenario_fwd[i+1,.])
}

other_cost_inc = (other_cost_hrt:/reg_inc_georder)*100000
other_cost_inc=editmissing(other_cost_inc,0)

/*(4) (b) Other time*/
other_time = J(j_t,j_r*j_h,0)
other_time[mode_backcast+1..mode_backcast+mode_input_t,.] = mode_time[mode_input_t*3+1..mode_input_t*4,.]
other_time_hrt = other_time

time_back = J(mode_backcast,1,other_time_hrt[mode_backcast+1,.])
time_fwd = J(mode_forecast,1,other_time_hrt[mode_backcast+mode_input_t,.])
other_time_hrt = (time_back\other_time_hrt[mode_backcast+1..mode_backcast+mode_input_t,.]\J(6,1,other_time_hrt[mode_backcast+mode_input_t,.])\time_fwd)

/*(4) (c) Other peak*/
other_peak = J(j_t,j_r*j_h,0)
other_peak[mode_backcast+1..(mode_backcast+mode_input_t),.] = peak[mode_input_t*3+1..mode_input_t*4,.]
other_peak_hrt = J(1,j_r*j_h,other_peak)
peak_back = J(mode_backcast,1,other_peak_hrt[mode_backcast+1,.])
peak_fwd = J(mode_forecast,1,other_peak_hrt[mode_backcast+mode_input_t,.])
other_peak_hrt = (peak_back\other_peak_hrt[(mode_backcast+1)..(mode_backcast+mode_input_t),.]\J(6,1,other_peak_hrt[mode_backcast+mode_input_t,.])\peak_fwd)

/*(5)(a) Passenger cost*/
passenger_cost = J(j_t,j_r*j_h,0)
passenger_cost[mode_backcast+1..mode_backcast+mode_input_t,.] = cost_perk[mode_input_t*4+1..mode_input_t*5,.]
/*passenger_cost_hrt = J(j_t,j_r*j_h,passenger_cost)*/
passenger_cost_hrt = passenger_cost
for (i=1; i<=mode_backcast; i++){
    passenger_cost_hrt[mode_backcast+1-i,.]= passenger_cost[mode_backcast+2-i,.]:*cost_back[mode_backcast+1-i,.]
}

for (i=mode_backcast+mode_input_t; i<=mode_backcast+mode_input_t+mode_forecast-1; i++){
    passenger_cost_hrt[i+1,.]= passenger_cost_hrt[i,.]:*(cost_fwd[i+1,.]+ pt_price_scenario_fwd[i+1,.])
}

passenger_cost_inc = (passenger_cost_hrt:/reg_inc_georder)*100000
passenger_cost_inc=editmissing(passenger_cost_inc,0)

/*(5) (b) Passenger time*/
passenger_time = J(j_t,j_r*j_h,0)
passenger_time[mode_backcast+1..mode_backcast+mode_input_t,.] = mode_time[mode_input_t*4+1..mode_input_t*5,.]
passenger_time_hrt = passenger_time

time_back = J(mode_backcast,1,passenger_time_hrt[mode_backcast+1,.])
time_fwd = J(mode_forecast,1,passenger_time_hrt[mode_backcast+mode_input_t,.])
passenger_time_hrt = (time_back\passenger_time_hrt[mode_backcast+1..mode_backcast+mode_input_t,.]\J(6,1,passenger_time_hrt[mode_backcast+mode_input_t,.])\time_fwd)
/*(5) (c) Passenger peak*/
passenger_peak = J(j_t,j_r*j_h,0)
passenger_peak[mode_backcast+1..(mode_backcast+mode_input_t),.] = peak[mode_input_t*4+1..mode_input_t*5,.]
passenger_peak_hrt = J(1,j_r*j_h,passenger_peak)
peak_back = J(mode_backcast,1,passenger_peak_hrt[mode_backcast+1,.])
peak_fwd = J(mode_forecast,1,passenger_peak_hrt[mode_backcast+mode_input_t,.])
passenger_peak_hrt = (peak_back\passenger_peak_hrt[(mode_backcast+1)..(mode_backcast+mode_input_t),.]\J(6,1,passenger_peak_hrt[mode_backcast+mode_input_t,.])\peak_fwd)


/*(6)(a) Taxi cost*/
taxi_cost = J(j_t,j_r*j_h,0)
taxi_cost[mode_backcast+1..mode_backcast+mode_input_t,.] = cost_perk[mode_input_t*5+1..mode_input_t*6,.]
/*taxi_cost_hrt = J(j_t,j_r*j_h,taxi_cost)*/
taxi_cost_hrt = taxi_cost
for (i=1; i<=mode_backcast; i++){
    taxi_cost_hrt[mode_backcast+1-i,.]= taxi_cost[mode_backcast+2-i,.]:*cost_back[mode_backcast+1-i,.]
}

for (i=mode_backcast+mode_input_t; i<=mode_backcast+mode_input_t+mode_forecast-1; i++){
    taxi_cost_hrt[i+1,.]= taxi_cost_hrt[i,.]:*(cost_fwd[i+1,.]+ pt_price_scenario_fwd[i+1,.])
}

taxi_cost_inc = (taxi_cost_hrt:/reg_inc_georder)*100000
taxi_cost_inc=editmissing(taxi_cost_inc,0)

/*(6) (b) Taxi time*/
taxi_time = J(j_t,j_r*j_h,0)
taxi_time[mode_backcast+1..mode_backcast+mode_input_t,.] = mode_time[mode_input_t*5+1..mode_input_t*6,.]
taxi_time_hrt = taxi_time

time_back = J(mode_backcast,1,taxi_time_hrt[mode_backcast+1,.])
time_fwd = J(mode_forecast,1,taxi_time_hrt[mode_backcast+mode_input_t,.])
taxi_time_hrt = (time_back\taxi_time_hrt[mode_backcast+1..mode_backcast+mode_input_t,.]\J(6,1,taxi_time_hrt[mode_backcast+mode_input_t,.])\time_fwd)

/*(6) (c) Taxi peak*/
taxi_peak = J(j_t,j_r*j_h,0)
taxi_peak[mode_backcast+1..(mode_backcast+mode_input_t),.] = peak[mode_input_t*5+1..mode_input_t*6,.]
taxi_peak_hrt = J(1,j_r*j_h,taxi_peak)
peak_back = J(mode_backcast,1,taxi_peak_hrt[mode_backcast+1,.])
peak_fwd = J(mode_forecast,1,taxi_peak_hrt[mode_backcast+mode_input_t,.])
taxi_peak_hrt = (peak_back\taxi_peak_hrt[(mode_backcast+1)..(mode_backcast+mode_input_t),.]\J(6,1,taxi_peak_hrt[mode_backcast+mode_input_t,.])\peak_fwd)


/*(7)(a) Train cost*/
train_cost = J(j_t,j_r*j_h,0)
train_cost[mode_backcast+1..mode_backcast+mode_input_t,.] = cost_perk[mode_input_t*6+1..mode_input_t*7,.]
/*train_cost_hrt = J(j_t,j_r*j_h,train_cost)*/
train_cost_hrt = train_cost
for (i=1; i<=mode_backcast; i++){
    train_cost_hrt[mode_backcast+1-i,.]= train_cost[mode_backcast+2-i,.]:*cost_back[mode_backcast+1-i,.]
}

for (i=mode_backcast+mode_input_t; i<=mode_backcast+mode_input_t+mode_forecast-1; i++){
    train_cost_hrt[i+1,.]= train_cost_hrt[i,.]:*(cost_fwd[i+1,.]+ pt_price_scenario_fwd[i+1,.])
}

train_cost_inc = (train_cost_hrt:/reg_inc_georder)*100000
train_cost_inc=editmissing(train_cost_inc,0)

/*(7) (b) Train time*/
train_time = J(j_t,j_r*j_h,0)
train_time[mode_backcast+1..mode_backcast+mode_input_t,.] = mode_time[mode_input_t*6+1..mode_input_t*7,.]
train_time_hrt = train_time

time_back = J(mode_backcast,1,train_time_hrt[mode_backcast+1,.])
time_fwd = J(mode_forecast,1,train_time_hrt[mode_backcast+mode_input_t,.])
train_time_hrt = (time_back\train_time_hrt[mode_backcast+1..mode_backcast+mode_input_t,.]\J(6,1,train_time_hrt[mode_backcast+mode_input_t,.])\time_fwd)

/*(7) (c) Train peak*/
train_peak = J(j_t,j_r*j_h,0)
train_peak[mode_backcast+1..(mode_backcast+mode_input_t),.] = peak[mode_input_t*6+1..mode_input_t*7,.]
train_peak_hrt = J(1,j_r*j_h,train_peak)
peak_back = J(mode_backcast,1,train_peak_hrt[mode_backcast+1,.])
peak_fwd = J(mode_forecast,1,train_peak_hrt[mode_backcast+mode_input_t,.])
train_peak_hrt = (peak_back\train_peak_hrt[(mode_backcast+1)..(mode_backcast+mode_input_t),.]\J(6,1,train_peak_hrt[mode_backcast+mode_input_t,.])\peak_fwd)

/*(8)(a) Walk cost*/
walk_cost = J(j_t,j_r*j_h,0)
/*walk_cost[1,.] = cost_perk[7*mode_input_t+1..mode_input_t*8,.]*/
walk_cost_hrt = walk_cost
walk_cost_inc = (walk_cost_hrt:/reg_inc_georder)*100000


/*(8) (b) Walk time*/
walk_time = J(j_t,j_r*j_h,0)
walk_time[mode_backcast+1..mode_backcast+mode_input_t,.] = mode_time[mode_input_t*7+1..mode_input_t*8,.]
/*walk_time_hrt = J(walk_time,j_t,j_r,j_h)*/
walk_time_hrt = walk_time

time_back = J(mode_backcast,1,walk_time_hrt[mode_backcast+1,.])
time_fwd = J(mode_forecast,1,walk_time_hrt[mode_backcast+mode_input_t,.])
walk_time_hrt = (time_back\walk_time_hrt[mode_backcast+1..mode_backcast+mode_input_t,.]\J(6,1,walk_time_hrt[mode_backcast+mode_input_t,.])\time_fwd)

/*(8) (c) Walk peak*/
walk_peak = J(j_t,j_r*j_h,0)
walk_peak[mode_backcast+1..(mode_backcast+mode_input_t),.] = peak[mode_input_t*7+1..mode_input_t*8,.]
walk_peak_hrt = J(j_t,j_r*j_h,walk_peak)
peak_back = J(mode_backcast,1,walk_peak_hrt[mode_backcast+1,.])
peak_fwd = J(mode_forecast,1,walk_peak_hrt[mode_backcast+mode_input_t,.])
walk_peak_hrt = (peak_back\walk_peak_hrt[(mode_backcast+1)..(mode_backcast+mode_input_t),.]\J(6,1,walk_peak_hrt[mode_backcast+mode_input_t,.])\peak_fwd)



/* Cars*/
/* Note: all matrices should be of the same order 59x(12x6)*/
/*veh_hrt = permute(veh_reg_by_hh_type,[1,3,2]);*/
veh_hrt = veh_reg_by_hh_type
hh_hrt_modelregorder1 = (alon_reg,cple_reg,multi_reg,multif_reg,onep_reg,twop_reg)
/* Calibrating for the population trend 
hh_hrt1_geo_sum = rowsum(hh_hrt_modelregorder1)
hh_hrt1_geo_shr = hh_hrt_modelregorder1:/hh_hrt1_geo_sum
hh_hrt1_geo_base_cal = hh_hrt1_geo_sum[29]/pop[29]
hh_hrt1_geo_sum_cal = (hh_hrt1_geo_sum[1..29]\(hh_hrt1_geo_base_cal:*pop[30..rows(pop)]))
hh_hrt1_geo_cal = hh_hrt1_geo_shr:*hh_hrt1_geo_sum_cal
hh_hrt_modelregorder1_nocal = hh_hrt_modelregorder1
hh_hrt_modelregorder1 = hh_hrt1_geo_cal
*/
 
hh_hrt1_geo_sum = rowsum(hh_hrt_modelregorder1)
hh_hrt1_geo_shr = hh_hrt_modelregorder1:/hh_hrt1_geo_sum
hh_hrt1_geo_base_cal = pop_mbie2250[29]/hh_hrt1_geo_sum[59]
pop_hrta_mul = hh_hrt1_geo_base_cal:*hh_hrt1_geo_sum[31..rows(pop)]
hh_hrt1_geo_sum_cal = (pop[1..30]\pop_hrta_mul)
hh_hrt1_geo_cal = hh_hrt1_geo_shr:*hh_hrt1_geo_sum_cal
hh_hrt_modelregorder1_nocal = hh_hrt_modelregorder1
hh_hrt_modelregorder1 = hh_hrt1_geo_cal

hh_hrt_modelregorder = (rowshape(hh_hrt_modelregorder1',72)')

/* SCENARIO: Adjust population to MBIE's 
pop_hrta_sum = rowsum(pop_hrta)
pop_hrta_shr = pop_hrta:/pop_hrta_sum
pop_hrta_base_cal = pop_mbie2250[1]/pop_hrta_sum[30]
pop_hrta_mul = pop_hrta_base_cal:*pop_hrta_sum[30..rows(pop)]
pop_hrta_sum_cal = (pop[1..29]\pop_hrta_mul)

pop_hrta_cal = pop_hrta_shr:*pop_hrta_sum_cal

pop_hrta = pop_hrta_cal
*/

/*hh_hrt_modelregorder = J(1, j_r,j_h, hh_hrt_modelregorder1)*/
cars_hrt_modelregorder = veh_hrt:/hh_hrt_modelregorder
/*ages_hrt = reshape(ages_hrt,j_t,j_r,j_h);
dens_hrt = reshape(dens_hrt,j_t,j_r,j_h);*/

hh_hrt_georder=J(TL,12*6,0)
cars_hrt_georder=J(TL,12*6,0)
ages_hrt_georder=J(TL,12*6,0)
dens_hrt_georder=J(TL,12*6,0)
for (i = 1; i<=12; i++) { 
	for (j=1; j<=6; j++){
		hh_hrt_georder[.,(i-1)*6+j]= hh_hrt_modelregorder[.,(model2geo[i]-1)*6+j] 
		cars_hrt_georder[.,(i-1)*6+j] = cars_hrt_modelregorder[.,(model2geo[i]-1)*6+j] 
		ages_hrt_georder[.,(i-1)*6+j] = ages_hrt1[.,(alph2geo[i]-1)*6+j] 
		dens_hrt_georder[.,(i-1)*6+j] = dens_hrt_reshape[.,(alph2geo[i]-1)*6+j] 
	}
}
ages_hrt_georder = exp(ages_hrt_georder)
hh_type_hrt = (J(j_t,j_r,1)*1,J(j_t,j_r,1)*2,J(j_t,j_r,1)*5,J(j_t,j_r,1)*6,J(j_t,j_r,1)*4,J(j_t,j_r,1)*3)
/* Construct predictor matrices */
akl_wel_mode_n = 8 
regional_mode_n = 5 
/* Variables are c, cost_hrt, ages_hrt, hhtype_hrt, cars_hrt, peak_hrt, time_hrt */
logit_rows = 408 
j_a = Ages_n 
/*Note the size of X_logit is (rows x time x ages) x (region x HHs)*/
/*This used to be X_logit = zeros(logit_rows,j_r,j_h,j_t,j_a)*/
X_logit= J(logit_rows* j_t, j_r*j_h*j_a,0)
/* Allow for 'exogenous' trends in mode shares by tweaking constants*/
/* initially just for PT (buses and trains)*/
constants = J(j_t*(akl_wel_mode_n-1), 12, 1) 
bus_exog_adjustment_speed = (bus_exog_adjustment_speed\36:*J(mode_forecast-length(bus_exog_adjustment_speed),1,1))
train_exog_adjustment_speed = (train_exog_adjustment_speed\(36:*J(mode_forecast-length(train_exog_adjustment_speed),1,1))) 
/*
	constants[TL-mode_forecast+1..TL,1,2] = (J(mode_forecast,1,1):*bus_exog_rate[2]):^bus_exog_adjustment_speed
	constants[TL-mode_forecast+1..TL,1,8] = (J(mode_forecast,1,1):*bus_exog_rate[8]):^bus_exog_adjustment_speed
	constants[TL-mode_forecast+1..TL,6,1*TL+1..2*TL] = (J(mode_forecast,1,1):*bus_exog_rate[2]):^train_exog_adjustment_speed
	constants[TL-mode_forecast+1..TL,6,8] = (J(mode_forecast,1,1):*bus_exog_rate[8]):^train_exog_adjustment_speed
	constants_idx = (1,3,4,5,6,7,9,10,11,12)


for (j = 1; j<=7; j++){
    for (i = 1; i<=length(constants_idx);i++){
    constants[j,constants_idx(i),TL-mode_forecast+1:end) = (J(mode_forecast,1,1):*bus_exog_rate[constants_idx(i))):^bus_exog_adjustment_speed
    }
}
*/
D1 = J(408/8,j_r*j_h*j_a,0)
D2 = J(408/8,j_r*j_h*j_a,0)
D3 = J(408/8,j_r*j_h*j_a,0)
D4 = J(408/8,j_r*j_h*j_a,0)
D5 = J(408/8,j_r*j_h*j_a,0)
D6 = J(408/8,j_r*j_h*j_a,0)
D7 = J(408/8,j_r*j_h*j_a,0)
D8 = J(408/8,j_r*j_h*j_a,0)

/*Note the size of X_logit is (rows x time x ages) x (region x HHs)*/
/*This used to be X_logit = zeros(logit_rows,j_r,j_h,j_t,j_a)*/
for (i=1;i<=j_t;i++){
	for (a=1;a<=j_a;a++){  
        for (j=1;j<=j_h;j++){
            for (r=1;r<=12;r++){
                region = r
                if ((region==2)||(region==8)){
					
					D1[.,a*(r-1)*j_h+j]=(J(7,1,1)\drive_cost_inc[i,(r-1)*j_h+j]\J(akl_wel_mode_n-1,1,a)\J(akl_wel_mode_n-1,1,hh_type_hrt[i,(r-1)*j_h+j])\J(akl_wel_mode_n-1,1,cars_hrt_georder[i,(r-1)*j_h+j])\J(akl_wel_mode_n-1,1,dens_hrt_georder[i,(r-1)*j_h+j])\J(akl_wel_mode_n-1,1,drive_peak_hrt[i,(r-1)*j_h+j])\J(akl_wel_mode_n,1,drive_time_hrt[i,(r-1)*j_h+j]))
					D2[.,a*(r-1)*j_h+j]=(J(7,1,1)\bus_cost_inc[i,(r-1)*j_h+j]\J(akl_wel_mode_n-1,1,a)\J(akl_wel_mode_n-1,1,hh_type_hrt[i,(r-1)*j_h+j])\J(akl_wel_mode_n-1,1,cars_hrt_georder[i,(r-1)*j_h+j])\J(akl_wel_mode_n-1,1,dens_hrt_georder[i,(r-1)*j_h+j])\J(akl_wel_mode_n-1,1,drive_peak_hrt[i,(r-1)*j_h+j])\J(akl_wel_mode_n,1,bus_time_hrt[i,(r-1)*j_h+j]))
					D3[.,a*(r-1)*j_h+j]=(J(7,1,1)\cycle_cost_inc[i,(r-1)*j_h+j]\J(akl_wel_mode_n-1,1,a)\J(akl_wel_mode_n-1,1,hh_type_hrt[i,(r-1)*j_h+j])\J(akl_wel_mode_n-1,1,cars_hrt_georder[i,(r-1)*j_h+j])\J(akl_wel_mode_n-1,1,dens_hrt_georder[i,(r-1)*j_h+j])\J(akl_wel_mode_n-1,1,drive_peak_hrt[i,(r-1)*j_h+j])\J(akl_wel_mode_n,1,cycle_time_hrt[i,(r-1)*j_h+j]))	
					D4[.,a*(r-1)*j_h+j]=(J(7,1,1)\other_cost_inc[i,(r-1)*j_h+j]\J(akl_wel_mode_n-1,1,a)\J(akl_wel_mode_n-1,1,hh_type_hrt[i,(r-1)*j_h+j])\J(akl_wel_mode_n-1,1,cars_hrt_georder[i,(r-1)*j_h+j])\J(akl_wel_mode_n-1,1,dens_hrt_georder[i,(r-1)*j_h+j])\J(akl_wel_mode_n-1,1,drive_peak_hrt[i,(r-1)*j_h+j])\J(akl_wel_mode_n,1,other_time_hrt[i,(r-1)*j_h+j]))		
					D5[.,a*(r-1)*j_h+j]=(J(7,1,1)\passenger_cost_inc[i,(r-1)*j_h+j]\J(akl_wel_mode_n-1,1,a)\J(akl_wel_mode_n-1,1,hh_type_hrt[i,(r-1)*j_h+j])\J(akl_wel_mode_n-1,1,cars_hrt_georder[i,(r-1)*j_h+j])\J(akl_wel_mode_n-1,1,dens_hrt_georder[i,(r-1)*j_h+j])\J(akl_wel_mode_n-1,1,drive_peak_hrt[i,(r-1)*j_h+j])\J(akl_wel_mode_n,1,passenger_time_hrt[i,(r-1)*j_h+j]))
					D6[.,a*(r-1)*j_h+j]=(J(7,1,1)\taxi_cost_inc[i,(r-1)*j_h+j]\J(akl_wel_mode_n-1,1,a)\J(akl_wel_mode_n-1,1,hh_type_hrt[i,(r-1)*j_h+j])\J(akl_wel_mode_n-1,1,cars_hrt_georder[i,(r-1)*j_h+j])\J(akl_wel_mode_n-1,1,dens_hrt_georder[i,(r-1)*j_h+j])\J(akl_wel_mode_n-1,1,drive_peak_hrt[i,(r-1)*j_h+j])\J(akl_wel_mode_n,1,taxi_time_hrt[i,(r-1)*j_h+j]))		
					D7[.,a*(r-1)*j_h+j]=(J(7,1,1)\train_cost_inc[i,(r-1)*j_h+j]\J(akl_wel_mode_n-1,1,a)\J(akl_wel_mode_n-1,1,hh_type_hrt[i,(r-1)*j_h+j])\J(akl_wel_mode_n-1,1,cars_hrt_georder[i,(r-1)*j_h+j])\J(akl_wel_mode_n-1,1,dens_hrt_georder[i,(r-1)*j_h+j])\J(akl_wel_mode_n-1,1,drive_peak_hrt[i,(r-1)*j_h+j])\J(akl_wel_mode_n,1,train_time_hrt[i,(r-1)*j_h+j]))
					D8[.,a*(r-1)*j_h+j]=(J(7,1,1)\walk_cost_inc[i,(r-1)*j_h+j]\J(akl_wel_mode_n-1,1,a)\J(akl_wel_mode_n-1,1,hh_type_hrt[i,(r-1)*j_h+j])\J(akl_wel_mode_n-1,1,cars_hrt_georder[i,(r-1)*j_h+j])\J(akl_wel_mode_n-1,1,dens_hrt_georder[i,(r-1)*j_h+j])\J(akl_wel_mode_n-1,1,drive_peak_hrt[i,(r-1)*j_h+j])\J(akl_wel_mode_n,1,walk_time_hrt[i,(r-1)*j_h+j]))
								}
								else{
					D1[.,a*(r-1)*j_h+j]=(J(4,1,1)\J(3,1,0)\drive_cost_inc[i,(r-1)*j_h+j]\J(regional_mode_n-1,1,a)\J(3,1,0)\J(regional_mode_n-1,1,hh_type_hrt[i,(r-1)*j_h+j])\J(3,1,0)\J(regional_mode_n-1,1,cars_hrt_georder[i,(r-1)*j_h+j])\J(3,1,0)\J(regional_mode_n-1,1,0)\J(3,1,0)\J(regional_mode_n-1,1,drive_peak_hrt[i,(r-1)*j_h+j])\J(3,1,0)\J(regional_mode_n,1,drive_time_hrt[i,(r-1)*j_h+j])\J(3,1,0))
					D2[.,a*(r-1)*j_h+j]=(J(4,1,1)\J(3,1,0)\bus_cost_inc[i,(r-1)*j_h+j]\J(regional_mode_n-1,1,a)\J(3,1,0)\J(regional_mode_n-1,1,hh_type_hrt[i,(r-1)*j_h+j])\J(3,1,0)\J(regional_mode_n-1,1,cars_hrt_georder[i,(r-1)*j_h+j])\J(3,1,0)\J(regional_mode_n-1,1,0)\J(3,1,0)\J(regional_mode_n-1,1,drive_peak_hrt[i,(r-1)*j_h+j])\J(3,1,0)\J(regional_mode_n,1,bus_time_hrt[i,(r-1)*j_h+j])\J(3,1,0))
					D3[.,a*(r-1)*j_h+j]=(J(4,1,1)\J(3,1,0)\cycle_cost_inc[i,(r-1)*j_h+j]\J(regional_mode_n-1,1,a)\J(3,1,0)\J(regional_mode_n-1,1,hh_type_hrt[i,(r-1)*j_h+j])\J(3,1,0)\J(regional_mode_n-1,1,cars_hrt_georder[i,(r-1)*j_h+j])\J(3,1,0)\J(regional_mode_n-1,1,0)\J(3,1,0)\J(regional_mode_n-1,1,drive_peak_hrt[i,(r-1)*j_h+j])\J(3,1,0)\J(regional_mode_n,1,cycle_time_hrt[i,(r-1)*j_h+j])\J(3,1,0))
					D5[.,a*(r-1)*j_h+j]=(J(4,1,1)\J(3,1,0)\passenger_cost_inc[i,(r-1)*j_h+j]\J(regional_mode_n-1,1,a)\J(3,1,0)\J(regional_mode_n-1,1,hh_type_hrt[i,(r-1)*j_h+j])\J(3,1,0)\J(regional_mode_n-1,1,cars_hrt_georder[i,(r-1)*j_h+j])\J(3,1,0)\J(regional_mode_n-1,1,0)\J(3,1,0)\J(regional_mode_n-1,1,drive_peak_hrt[i,(r-1)*j_h+j])\J(3,1,0)\J(regional_mode_n,1,passenger_time_hrt[i,(r-1)*j_h+j])\J(3,1,0))
					D8[.,a*(r-1)*j_h+j]=(J(4,1,1)\J(3,1,0)\walk_cost_inc[i,(r-1)*j_h+j]\J(regional_mode_n-1,1,a)\J(3,1,0)\J(regional_mode_n-1,1,hh_type_hrt[i,(r-1)*j_h+j])\J(3,1,0)\J(regional_mode_n-1,1,cars_hrt_georder[i,(r-1)*j_h+j])\J(3,1,0)\J(regional_mode_n-1,1,0)\J(3,1,0)\J(regional_mode_n-1,1,drive_peak_hrt[i,(r-1)*j_h+j])\J(3,1,0)\J(regional_mode_n,1,walk_time_hrt[i,(r-1)*j_h+j])\J(3,1,0))
								}
			}
		}
		X_logit[(i-1)*logit_rows+1..i*logit_rows,.]=D1\D2\D3\D4\D5\D6\D7\D8
	}
}

/* Estimate choice probabilities */

yhat = J(rows(X_logit),cols(X_logit),0)
logp_m = J(mode_n*j_t,j_r*j_h*j_a,0)
p_mode = J(mode_n*j_t,j_r*j_h*j_a,0)


logitreg2 = J(51*8*12,1,0)
logitreg_reg = J(51*8,j_r,0)
logitreg_reorder = logitreg[817..946]\logitreg[1..408]\logitreg[947..1596]\logitreg[409..816]\logitreg[1597..2116]
logitmap_reorder = logitmap[817..946]\logitmap[1..408]\logitmap[947..1596]\logitmap[409..816]\logitmap[1597..2116]
logitcoeff_reorder = logitcoeff[817..946]\logitcoeff[1..408]\logitcoeff[947..1596]\logitcoeff[409..816]\logitcoeff[1597..2116]
logitmode_reorder = logitmode[817..946]\logitmode[1..408]\logitmode[947..1596]\logitmode[409..816]\logitmode[1597..2116]
logitmode_reorder_f = J(51*8*12,1,0)




logitcomap = logitcoeff_reorder:*logitmap_reorder
for (r=1;r<=rows(logitcoeff);r++){
        if ((logitreg_reorder[r]==2)||(logitreg_reorder[r]==8)){
				logitreg2[r..r+50] = (logitreg_reorder[r..(r+6)]\logitreg_reorder[r+7]\logitreg_reorder[r+8..r+14]\logitreg_reorder[r+15..r+21]\logitreg_reorder[r+22..r+28]\logitreg_reorder[r+29..r+35]\logitreg_reorder[r+36..r+42]\logitreg_reorder[r+43..r+50])
				r=r+50
		}
		else{
			
			logitreg2[r..r+50] = (logitreg_reorder[r..(r+3)]\J(3,1,0)\logitreg_reorder[r+4]\logitreg_reorder[r+5..r+8]\J(3,1,0)\logitreg_reorder[r+9..r+12]\J(3,1,0)\logitreg_reorder[r+13..r+16]\J(3,1,0)\logitreg_reorder[r+17..r+20]\J(3,1,0)\logitreg_reorder[r+17..r+20]\J(3,1,0)\logitreg_reorder[r+21..r+25]\J(3,1,0))
r=r+25			
		
		}
}
for (r=1;r<=12;r++){
		logitreg_reg[.,r] = logitreg2[(r-1)*408+1..r*408]
}


for (r=1;r<=rows(logitcoeff);r++){
        if ((logitreg_reorder[r]==2)||(logitreg_reorder[r]==8)){
				logitmode_reorder_f[r..r+408] = (logitmode_reorder[r..r+408])
				r=r+407
		}
		else{
			logitmode_reorder_f[r..r+50] = (logitmode_reorder[r..(r+3)]\J(3,1,0)\logitmode_reorder[r+4]\logitmode_reorder[r+5..r+8]\J(3,1,0)\logitmode_reorder[r+9..r+12]\J(3,1,0)\logitmode_reorder[r+13..r+16]\J(3,1,0)\logitmode_reorder[r+17..r+20]\J(3,1,0)\logitmode_reorder[r+17..r+20]\J(3,1,0)\logitmode_reorder[r+21..r+25]\J(3,1,0))
r=r+25
		}
}

logitmode_reorder_fin = J(408,12,0)
for (z=1;z<=12;z++){
	logitmode_reorder_fin[.,z] = logitmode_reorder_f[(z-1)*408+1..z*408]
}

logitmode1 = (logitmode_reorder_f:==1)
logitmode2 = (logitmode_reorder_f:==2)
logitmode3 = (logitmode_reorder_f:==3)
logitmode4 = (logitmode_reorder_f:==4)
logitmode5 = (logitmode_reorder_f:==5)
logitmode6 = (logitmode_reorder_f:==6)
logitmode7 = (logitmode_reorder_f:==7)
logitmode8 = (logitmode_reorder_f:==8)


/* THIS LOOP REVISED!*/

logit_reg_rep = J(j_t,1,logitreg_reg)
logit_reg_rep_exp = J(rows(logit_reg_rep),j_r*j_h*j_a,0)
for (r=1;r<=12;r++){
	logit_reg_rep_exp[.,(r-1)*j_h*j_a+1..r*j_h*j_a] = J(1,j_a,J(1,j_h,logit_reg_rep[.,r]))
}
yhat = X_logit:*logit_reg_rep_exp

for (i=1;i<=j_t;i++){
	for (a=1;a<=j_a;a++){  
		for (r=1;r<=12;r++){
			for (j=1;j<=j_h;j++){
					c = (a-1)*j_r*j_h+(r-1)*j_h+j
					logp_m[(i-1)*mode_n+1..i*mode_n,c] = (exp(rowsum(colsum(yhat[(i-1)*logit_rows+1..i*logit_rows,c]:*logitmode1[(r-1)*408+1..r*408])))\exp(rowsum(colsum(yhat[(i-1)*logit_rows+1..i*logit_rows,c]:*logitmode2[(r-1)*408+1..r*408])))\exp(rowsum(colsum(yhat[(i-1)*logit_rows+1..i*logit_rows,c]:*logitmode3[(r-1)*408+1..r*408])))\exp(rowsum(colsum(yhat[(i-1)*logit_rows+1..i*logit_rows,c]:*logitmode4[(r-1)*408+1..r*408])))\exp(rowsum(colsum(yhat[(i-1)*logit_rows+1..i*logit_rows,c]:*logitmode5[(r-1)*408+1..r*408])))\exp(rowsum(colsum(yhat[(i-1)*logit_rows+1..i*logit_rows,c]:*logitmode6[(r-1)*408+1..r*408])))\exp(rowsum(colsum(yhat[(i-1)*logit_rows+1..i*logit_rows,c]:*logitmode7[(r-1)*408+1..r*408])))\exp(rowsum(colsum(yhat[(i-1)*logit_rows+1..i*logit_rows,c]:*logitmode8[(r-1)*408+1..r*408]))))	
										if (a<16){
											if ((region==2)||(region==8)){
												logp_m[(i-1)*mode_n+1,(r-1)*j_a*j_h+j]=0
											}
											else{
												logp_m[(i-1)*mode_n+3,(r-1)*j_a*j_h+j]=0
											}
										}
										p_mode[(i-1)*mode_n+1..i*mode_n,c] = (logp_m[(i-1)*mode_n+1,c]:/colsum(logp_m[(i-1)*mode_n+1..i*mode_n,c])\ logp_m[(i-1)*mode_n+2,c]:/colsum(logp_m[(i-1)*mode_n+1..i*mode_n,c])\logp_m[(i-1)*mode_n+3,c]:/colsum(logp_m[(i-1)*mode_n+1..i*mode_n,c])\logp_m[(i-1)*mode_n+4,c]:/colsum(logp_m[(i-1)*mode_n+1..i*mode_n,c])\logp_m[(i-1)*mode_n+5,c]:/colsum(logp_m[(i-1)*mode_n+1..i*mode_n,c])\logp_m[(i-1)*mode_n+6,c]:/colsum(logp_m[(i-1)*mode_n+1..i*mode_n,c])\logp_m[(i-1)*mode_n+7,c]:/colsum(logp_m[(i-1)*mode_n+1..i*mode_n,c])\logp_m[(i-1)*mode_n+8,c]:/colsum(logp_m[(i-1)*mode_n+1..i*mode_n,c]))
			}
		}
	}
}
/* Convert choice probabilities to travel demands*/
/* Do some rearranging to get mode specific variables*/
bus_shr_hrta = J(j_t,j_r*j_h*j_a,0)
drive_shr_hrta = J(j_t,j_r*j_h*j_a,0)
passenger_shr_hrta = J(j_t,j_r*j_h*j_a,0)
cycle_shr_hrta = J(j_t,j_r*j_h*j_a,0)
train_shr_hrta = J(j_t,j_r*j_h*j_a,0)
walk_shr_hrta = J(j_t,j_r*j_h*j_a,0)
p_mode_missing = p_mode
p_mode=editmissing(p_mode,0)
/*data is (mode x reg x hh x t x a) - need to convert to t x hh x reg x a  by mode*/
for (i=1;i<=j_t;i++){
	for (a=1;a<=j_a;a++){  
        for (j=1;j<=j_h;j++){
            for (r=1;r<=12;r++){
				    bus_shr_hrta[i,a*(r-1)*j_h+j] = p_mode[2,a*(r-1)*j_h+j]
                    drive_shr_hrta[i,a*(r-1)*j_h+j] = p_mode[1,a*(r-1)*j_h+j]
                    passenger_shr_hrta[i,a*(r-1)*j_h+j] = p_mode[5,a*(r-1)*j_h+j]
                    cycle_shr_hrta[i,a*(r-1)*j_h+j] = p_mode[3,a*(r-1)*j_h+j]
                    train_shr_hrta[i,a*(r-1)*j_h+j] = p_mode[7,a*(r-1)*j_h+j]
                    walk_shr_hrta[i,a*(r-1)*j_h+j] = p_mode[8,a*(r-1)*j_h+j]
			}
		}
	}
}

/* Calculate age weights*/
/* Note that presently ages are weighted equally (so journeys per year per*/
/* person per hh is the same for all ages of people in the household)*/
/* Model development could look to improve this.*/

/*People by age by region by hh_type (collected from population model) */
/* so TLx101x6x12*/
/*pop_tahr = cat(nor_alon_all,nor_cple_all,nor_mult_all,nor_multif_all,nor_onep_all,nor_twop_all),...
                cat(3,akl_alon_all,akl_cple_all,akl_mult_all,akl_multif_all,akl_onep_all,akl_twop_all),...
                cat(3,wai_alon_all,wai_cple_all,wai_mult_all,wai_multif_all,wai_onep_all,wai_twop_all),...
                cat(3,bop_alon_all,bop_cple_all,bop_mult_all,bop_multif_all,bop_onep_all,bop_twop_all),...
                cat(3,gis_alon_all,gis_cple_all,gis_mult_all,gis_multif_all,gis_onep_all,gis_twop_all),...
                cat(3,tar_alon_all,tar_cple_all,tar_mult_all,tar_multif_all,tar_onep_all,tar_twop_all),...
                cat(3,man_alon_all,man_cple_all,man_mult_all,man_multif_all,man_onep_all,man_twop_all),...
                cat(3,wel_alon_all,wel_cple_all,wel_mult_all,wel_multif_all,wel_onep_all,wel_twop_all),...
                cat(3,usi_alon_all,usi_cple_all,usi_mult_all,usi_multif_all,usi_onep_all,usi_twop_all),...
                cat(3,can_alon_all,can_cple_all,can_mult_all,can_multif_all,can_onep_all,can_twop_all),...
                cat(3,otg_alon_all,otg_cple_all,otg_mult_all,otg_multif_all,otg_onep_all,otg_twop_all),...
                cat(3,sth_alon_all,sth_cple_all,sth_mult_all,sth_multif_all,sth_onep_all,sth_twop_all));
*/
pop_hrta = J(j_t,j_r*j_h*j_a,0)

E1 = J(j_t,6,0)
	for (a=1;a<=j_a;a++){  
				E1=(nor_alon_all[.,a],nor_cple_all[.,a],nor_mult_all[.,a],nor_multif_all[.,a],nor_onep_all[.,a],nor_twop_all[.,a])
				pop_hrta[.,(a-1)*j_h*j_r+1..a*j_h*j_r]=(E1,akl_alon_all[.,a],akl_cple_all[.,a],akl_mult_all[.,a],akl_multif_all[.,a],akl_onep_all[.,a],akl_twop_all[.,a],wai_alon_all[.,a],wai_cple_all[.,a],wai_mult_all[.,a],wai_multif_all[.,a],wai_onep_all[.,a],wai_twop_all[.,a],bop_alon_all[.,a],bop_cple_all[.,a],bop_mult_all[.,a],bop_multif_all[.,a],bop_onep_all[.,a],bop_twop_all[.,a],gis_alon_all[.,a],gis_cple_all[.,a],gis_mult_all[.,a],gis_multif_all[.,a],gis_onep_all[.,a],gis_twop_all[.,a],tar_alon_all[.,a],tar_cple_all[.,a],tar_mult_all[.,a],tar_multif_all[.,a],tar_onep_all[.,a],tar_twop_all[.,a],man_alon_all[.,a],man_cple_all[.,a],man_mult_all[.,a],man_multif_all[.,a],man_onep_all[.,a],man_twop_all[.,a],wel_alon_all[.,a],wel_cple_all[.,a],wel_mult_all[.,a],wel_multif_all[.,a],wel_onep_all[.,a],wel_twop_all[.,a],usi_alon_all[.,a],usi_cple_all[.,a],usi_mult_all[.,a],usi_multif_all[.,a],usi_onep_all[.,a],usi_twop_all[.,a],can_alon_all[.,a],can_cple_all[.,a],can_mult_all[.,a],can_multif_all[.,a],can_onep_all[.,a],can_twop_all[.,a],otg_alon_all[.,a],otg_cple_all[.,a],otg_mult_all[.,a],otg_multif_all[.,a],otg_onep_all[.,a],otg_twop_all[.,a],sth_alon_all[.,a],sth_cple_all[.,a],sth_mult_all[.,a],sth_multif_all[.,a],sth_onep_all[.,a],sth_twop_all[.,a])
	}
/* Calibrating for the population trend
pop_hrta_sum = rowsum(pop_hrta)
pop_hrta_shr = pop_hrta:/pop_hrta_sum
pop_hrta_base_cal = pop_hrta_sum[29]/pop[29]
pop_hrta_sum_cal = (pop_hrta_sum[1..29]\(pop_hrta_base_cal:*pop[30..rows(pop)]))
pop_hrta_cal = pop_hrta_shr:*pop_hrta_sum_cal
pop_hrta_nocal = pop_hrta
pop_hrta = pop_hrta_cal
 */
/* SCENARIO: Adjust population to MBIE's */
pop_hrta_sum = rowsum(pop_hrta)
pop_hrta_shr = pop_hrta:/pop_hrta_sum
pop_hrta_base_cal = pop_mbie2250[1]/pop_hrta_sum[31]
pop_hrta_mul = pop_hrta_base_cal:*pop_hrta_sum[31..rows(pop)]
pop_hrta_sum_cal = (pop[1..30]\pop_hrta_mul)
pop_hrta_cal = pop_hrta_shr:*pop_hrta_sum_cal
pop_hrta = pop_hrta_cal


/*hh_hrt = colshape(hh_hrt1',1)*/

hh_hrt = colshape(pop_hrta_cal',1)
		
/* Weighted shares*/
bus_shr_hrt = J(j_t,j_r*j_h,0)
drive_shr_hrt = J(j_t,j_r*j_h,0)
passenger_shr_hrt = J(j_t,j_r*j_h,0)
cycle_shr_hrt = J(j_t,j_r*j_h,0)
train_shr_hrt = J(j_t,j_r*j_h,0)
walk_shr_hrt = J(j_t,j_r*j_h,0)
/*[Below has been checked to see if shares add to 1 (and they do)*/
/*chk = bus_shr_hrt + drive_shr_hrt + passenger_shr_hrt + walk_shr_hrt + cycle_shr_hrt; */   
/*_asum matrices sum over the ''a'' dimension*/
pop_asum = J(j_t,j_r*j_h,0)
bus_shr_asum = J(j_t,j_r*j_h,0)
drive_shr_asum = J(j_t,j_r*j_h,0)
passenger_shr_asum = J(j_t,j_r*j_h,0)
cycle_shr_asum = J(j_t,j_r*j_h,0)
train_shr_asum = J(j_t,j_r*j_h,0)
walk_shr_asum = J(j_t,j_r*j_h,0)

bus_shr_hrta = pop_hrta:*bus_shr_hrta
drive_shr_hrta= pop_hrta:*drive_shr_hrta
passenger_shr_hrta=pop_hrta:*passenger_shr_hrta
cycle_shr_hrta=pop_hrta:*cycle_shr_hrta
train_shr_hrta=pop_hrta:*train_shr_hrta
walk_shr_hrta=pop_hrta:*walk_shr_hrta
	for (j=1;j<=j_h;j++){
            for (r=1;r<=12;r++){
				for (a=1;a<=j_a;a++){   
					pop_asum[.,(r-1)*j_h+j] = pop_hrta[.,(a-1)*j_h*j_r+j] + pop_asum[.,(r-1)*j_h+j]
					bus_shr_asum[.,(r-1)*j_h+j] = bus_shr_hrta[.,(a-1)*j_h*j_r+j] + bus_shr_asum[.,(r-1)*j_h+j]
					drive_shr_asum[.,(r-1)*j_h+j] = drive_shr_hrta[.,(a-1)*j_h*j_r+j] + drive_shr_asum[.,(r-1)*j_h+j]
					passenger_shr_asum[.,(r-1)*j_h+j] = passenger_shr_hrta[.,(a-1)*j_h*j_r+j] + passenger_shr_asum[.,(r-1)*j_h+j]
					cycle_shr_asum[.,(r-1)*j_h+j] = cycle_shr_hrta[.,(a-1)*j_h*j_r+j] + cycle_shr_asum[.,(r-1)*j_h+j]
					train_shr_asum[.,(r-1)*j_h+j] = train_shr_hrta[.,(a-1)*j_h*j_r+j] + train_shr_asum[.,(r-1)*j_h+j]
					walk_shr_asum[.,(r-1)*j_h+j] = walk_shr_hrta[.,(a-1)*j_h*j_r+j] + walk_shr_asum[.,(r-1)*j_h+j]
				}
			}
	}
bus_shr_hrt = bus_shr_asum:/pop_asum
drive_shr_hrt = drive_shr_asum:/pop_asum
passenger_shr_hrt = passenger_shr_asum:/pop_asum
cycle_shr_hrt = cycle_shr_asum:/pop_asum
train_shr_hrt = train_shr_asum:/pop_asum
walk_shr_hrt = walk_shr_asum:/pop_asum

/*Note that the journey data from the panel model*/
/* is in alphabetical order (akl = 1) while the data from the mode choice modelling is*/
/* in geographical order (akl = 2)*/
/*alph2geo = [6,	1,	11,	2,	4,	9,	5,	12,	10,	3,	7,	8] */

journeys_hrt_geoorder = J(length(journeys_hrt),1,0)
distance_hrt_geoorder = J(length(distance_hrt),1,0)
for (i=1;i<=12;i++){
	journeys_hrt_geoorder[(i-1)*j_h*j_t+1..i*j_h*j_t] = journeys_hrt[(alph2geo[i]-1)*j_h*j_t+1..alph2geo[i]*j_h*j_t]
	distance_hrt_geoorder[(i-1)*j_h*j_t+1..i*j_h*j_t] = distance_hrt[(alph2geo[i]-1)*j_h*j_t+1..alph2geo[i]*j_h*j_t]
}

bus_journeys_hrt =  colshape(bus_shr_hrt',1):*journeys_hrt_geoorder
drive_journeys_hrt = colshape(drive_shr_hrt',1):*journeys_hrt_geoorder
passenger_journeys_hrt = colshape(passenger_shr_hrt',1):*journeys_hrt_geoorder
cycle_journeys_hrt = colshape(cycle_shr_hrt',1):*journeys_hrt_geoorder
train_journeys_hrt = colshape(train_shr_hrt',1):*journeys_hrt_geoorder
walk_journeys_hrt = colshape(walk_shr_hrt',1):*journeys_hrt_geoorder


/*journeys_rt1 = sum(journeys_hrt_geoorder,3);
distance_rt1 = sum(distance_hrt_geoorder,3);*/
bus_dist_hrt1 = J(rows(distance_hrt_geoorder),cols(distance_hrt_geoorder),0)
drive_dist_hrt1 = J(rows(distance_hrt_geoorder),cols(distance_hrt_geoorder),0)
passenger_dist_hrt1 = J(rows(distance_hrt_geoorder),cols(distance_hrt_geoorder),0)
cycle_dist_hrt1 = J(rows(distance_hrt_geoorder),cols(distance_hrt_geoorder),0)
train_dist_hrt1 = J(rows(distance_hrt_geoorder),cols(distance_hrt_geoorder),0)
walk_dist_hrt1 = J(rows(distance_hrt_geoorder),cols(distance_hrt_geoorder),0)
for (i=1;i<=12;i++){
	bus_dist_hrt1[(i-1)*j_h*j_t+1..i*j_h*j_t] = bus_journeys_hrt[(i-1)*j_h*j_t+1..i*j_h*j_t]:*J(1,j_t*j_h,bus_fixed[i])'
	drive_dist_hrt1[(i-1)*j_h*j_t+1..i*j_h*j_t] = drive_journeys_hrt[(i-1)*j_h*j_t+1..i*j_h*j_t]:*J(1,j_t*j_h,drive_fixed[i])'
	passenger_dist_hrt1[(i-1)*j_h*j_t+1..i*j_h*j_t] = passenger_journeys_hrt[(i-1)*j_h*j_t+1..i*j_h*j_t]:*J(1,j_t*j_h,passenger_fixed[i])'
	cycle_dist_hrt1[(i-1)*j_h*j_t+1..i*j_h*j_t] = cycle_journeys_hrt[(i-1)*j_h*j_t+1..i*j_h*j_t]:*J(1,j_t*j_h,cycle_fixed[i])'
	train_dist_hrt1[(i-1)*j_h*j_t+1..i*j_h*j_t] = train_journeys_hrt[(i-1)*j_h*j_t+1..i*j_h*j_t]:*J(1,j_t*j_h,train_fixed[i])'
	walk_dist_hrt1[(i-1)*j_h*j_t+1..i*j_h*j_t] = walk_journeys_hrt[(i-1)*j_h*j_t+1..i*j_h*j_t]:*J(1,j_t*j_h,walk_fixed[i])'
}

tot_dist_hrt1 = bus_dist_hrt1 + drive_dist_hrt1 + passenger_dist_hrt1 + cycle_dist_hrt1 + train_dist_hrt1 + walk_dist_hrt1

bus_dist_shr_hrt = (bus_dist_hrt1:/tot_dist_hrt1)
bus_dist_hrt = bus_dist_shr_hrt:*distance_hrt_geoorder

drive_dist_shr_hrt = (drive_dist_hrt1:/tot_dist_hrt1)
drive_dist_hrt = drive_dist_shr_hrt:*distance_hrt_geoorder

passenger_dist_shr_hrt = (passenger_dist_hrt1:/tot_dist_hrt1)
passenger_dist_hrt = passenger_dist_shr_hrt:*distance_hrt_geoorder

cycle_dist_shr_hrt = (cycle_dist_hrt1:/tot_dist_hrt1)
cycle_dist_hrt = cycle_dist_shr_hrt:*distance_hrt_geoorder

train_dist_shr_hrt = (train_dist_hrt1:/tot_dist_hrt1)
train_dist_hrt = train_dist_shr_hrt:*distance_hrt_geoorder

walk_dist_shr_hrt = (walk_dist_hrt1:/tot_dist_hrt1)
walk_dist_hrt = walk_dist_shr_hrt:*distance_hrt_geoorder

bus_dist_rt=J(j_t*j_r,1,0)
drive_dist_rt=J(j_t*j_r,1,0)
passenger_dist_rt=J(j_t*j_r,1,0)
cycle_dist_rt=J(j_t*j_r,1,0)
train_dist_rt=J(j_t*j_r,1,0)
walk_dist_rt=J(j_t*j_r,1,0)
bus_dist_t=J(j_t,1,0)
drive_dist_t=J(j_t,1,0)
passenger_dist_t=J(j_t,1,0)
cycle_dist_t=J(j_t,1,0)
train_dist_t=J(j_t,1,0)
walk_dist_t=J(j_t,1,0)
/*The error below is ok - no impact on results*/
bus_dist_hrt_re = rowshape(bus_dist_hrt',72)'
drive_dist_hrt_re = rowshape(drive_dist_hrt',72)'
passenger_dist_hrt_re = rowshape(passenger_dist_hrt',72)'
cycle_dist_hrt_re = rowshape(cycle_dist_hrt',72)'
train_dist_hrt_re = rowshape(train_dist_hrt',72)'
walk_dist_hrt_re = rowshape(walk_dist_hrt',72)'
for (i = 1; i<=12; i++) { 
		bus_dist_rt[(i-1)*j_t+1..i*j_t] = rowsum(bus_dist_hrt_re[.,(i-1)*j_h+1..i*j_h])
		drive_dist_rt[(i-1)*j_t+1..i*j_t] = rowsum(drive_dist_hrt_re[.,(i-1)*j_h+1..i*j_h])
		passenger_dist_rt[(i-1)*j_t+1..i*j_t] = rowsum(passenger_dist_hrt_re[.,(i-1)*j_h+1..i*j_h])
		cycle_dist_rt[(i-1)*j_t+1..i*j_t] = rowsum(cycle_dist_hrt_re[.,(i-1)*j_h+1..i*j_h])
		train_dist_rt[(i-1)*j_t+1..i*j_t] = rowsum(train_dist_hrt_re[.,(i-1)*j_h+1..i*j_h])
		walk_dist_rt[(i-1)*j_t+1..i*j_t] = rowsum(walk_dist_hrt_re[.,(i-1)*j_h+1..i*j_h])
	}
bus_dist_t = rowsum(bus_dist_hrt_re)
drive_dist_t = rowsum(drive_dist_hrt_re)
passenger_dist_t = rowsum(passenger_dist_hrt_re)
cycle_dist_t = rowsum(cycle_dist_hrt_re)
train_dist_t = rowsum(train_dist_hrt_re)
walk_dist_t = rowsum(walk_dist_hrt_re)

/*
/*Distance by hh and mode over time*/
bus_dist_ht = squeeze(sum(bus_dist_hrt,2));
drive_dist_ht = squeeze(sum(drive_dist_hrt,2));
passenger_dist_ht = squeeze(sum(passenger_dist_hrt,2));
cycle_dist_ht = squeeze(sum(cycle_dist_hrt,2));
train_dist_ht = squeeze(sum(train_dist_hrt,2));
walk_dist_ht = squeeze(sum(walk_dist_hrt,2));
*/
/* Distance by region by mode over time */


nor_dist_mt = (bus_dist_rt[0*j_t+1..1*j_t]',drive_dist_rt[0*j_t+1..1*j_t]',passenger_dist_rt[0*j_t+1..1*j_t]',cycle_dist_rt[0*j_t+1..1*j_t]',train_dist_rt[0*j_t+1..1*j_t]',walk_dist_rt[0*j_t+1..1*j_t]')

akl_dist_mt =(bus_dist_rt[1*j_t+1..2*j_t]',drive_dist_rt[1*j_t+1..2*j_t]',passenger_dist_rt[1*j_t+1..2*j_t]',cycle_dist_rt[1*j_t+1..2*j_t]',train_dist_rt[1*j_t+1..2*j_t]',walk_dist_rt[1*j_t+1..2*j_t]')
            
wai_dist_mt =(bus_dist_rt[2*j_t+1..3*j_t]',drive_dist_rt[2*j_t+1..3*j_t]',passenger_dist_rt[2*j_t+1..3*j_t]',cycle_dist_rt[2*j_t+1..3*j_t]',train_dist_rt[2*j_t+1..3*j_t]',walk_dist_rt[2*j_t+1..3*j_t]')

bop_dist_mt =(bus_dist_rt[3*j_t+1..4*j_t]',drive_dist_rt[3*j_t+1..4*j_t]',passenger_dist_rt[3*j_t+1..4*j_t]',cycle_dist_rt[3*j_t+1..4*j_t]',train_dist_rt[3*j_t+1..4*j_t]',walk_dist_rt[3*j_t+1..4*j_t]')
            
gis_dist_mt =(bus_dist_rt[4*j_t+1..5*j_t]',drive_dist_rt[4*j_t+1..5*j_t]',passenger_dist_rt[4*j_t+1..5*j_t]',cycle_dist_rt[4*j_t+1..5*j_t]',train_dist_rt[4*j_t+1..5*j_t]',walk_dist_rt[4*j_t+1..5*j_t]')

tar_dist_mt =(bus_dist_rt[5*j_t+1..6*j_t]',drive_dist_rt[5*j_t+1..6*j_t]',passenger_dist_rt[5*j_t+1..6*j_t]',cycle_dist_rt[5*j_t+1..6*j_t]',train_dist_rt[5*j_t+1..6*j_t]',walk_dist_rt[5*j_t+1..6*j_t]')

man_dist_mt =(bus_dist_rt[6*j_t+1..7*j_t]',drive_dist_rt[6*j_t+1..7*j_t]',passenger_dist_rt[6*j_t+1..7*j_t]',cycle_dist_rt[6*j_t+1..7*j_t]',train_dist_rt[6*j_t+1..7*j_t]',walk_dist_rt[6*j_t+1..7*j_t]')

wel_dist_mt =(bus_dist_rt[7*j_t+1..8*j_t]',drive_dist_rt[7*j_t+1..8*j_t]',passenger_dist_rt[7*j_t+1..8*j_t]',cycle_dist_rt[7*j_t+1..8*j_t]',train_dist_rt[7*j_t+1..8*j_t]',walk_dist_rt[7*j_t+1..8*j_t]')

usi_dist_mt =(bus_dist_rt[8*j_t+1..9*j_t]',drive_dist_rt[8*j_t+1..9*j_t]',passenger_dist_rt[8*j_t+1..9*j_t]',cycle_dist_rt[8*j_t+1..9*j_t]',train_dist_rt[8*j_t+1..9*j_t]',walk_dist_rt[8*j_t+1..9*j_t]')

can_dist_mt =(bus_dist_rt[9*j_t+1..10*j_t]',drive_dist_rt[9*j_t+1..10*j_t]',passenger_dist_rt[9*j_t+1..10*j_t]',cycle_dist_rt[9*j_t+1..10*j_t]',train_dist_rt[9*j_t+1..10*j_t]',walk_dist_rt[9*j_t+1..10*j_t]')

otg_dist_mt =(bus_dist_rt[10*j_t+1..11*j_t]',drive_dist_rt[10*j_t+1..11*j_t]',passenger_dist_rt[10*j_t+1..11*j_t]',cycle_dist_rt[10*j_t+1..11*j_t]',train_dist_rt[10*j_t+1..11*j_t]',walk_dist_rt[10*j_t+1..11*j_t]')

sth_dist_mt =(bus_dist_rt[11*j_t+1..12*j_t]',drive_dist_rt[11*j_t+1..12*j_t]',passenger_dist_rt[11*j_t+1..12*j_t]',cycle_dist_rt[11*j_t+1..12*j_t]',train_dist_rt[11*j_t+1..12*j_t]',walk_dist_rt[11*j_t+1..12*j_t]')

end